﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace Chapitre_12
{
    public class Chapitre12 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        Matrix projection;
        Matrix view;

        Vector3 cameraPosition = new Vector3(0, 0, -7);
        Vector3 cameraTarget = Vector3.Zero;
        Vector3 cameraUpVector = Vector3.Up;

        Cube cube;
        Cube cubeB;

        float cameraYaw = 0;
        float moveSpeed = 0.1f;
        float rotationSpeed = 0.05f;

        public Chapitre12()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        protected override void Initialize()
        {
            float aspectRatio = graphics.GraphicsDevice.Viewport.Width / graphics.GraphicsDevice.Viewport.Height;
            Matrix.CreatePerspectiveFieldOfView(MathHelper.PiOver4, aspectRatio, 0.001f, 1000f, out projection);
            Matrix.CreateLookAt(ref cameraPosition, ref cameraTarget, ref cameraUpVector, out view);

            graphics.GraphicsDevice.RenderState.CullMode = CullMode.CullCounterClockwiseFace;

            cube = new Cube(graphics.GraphicsDevice, Vector3.Zero, 1, projection, view);
            cubeB = new Cube(graphics.GraphicsDevice, new Vector3(-4, 0, 0), 3, projection, view);
            
            base.Initialize();
        }

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);
        }

        protected override void Update(GameTime gameTime)
        {
            Matrix movement = Matrix.CreateRotationY(cameraYaw);

            if(Keyboard.GetState().IsKeyDown(Keys.Up) || Keyboard.GetState().IsKeyDown(Keys.Down))
            {
                Vector3 vector = Vector3.Zero;

                if (Keyboard.GetState().IsKeyDown(Keys.Up))
                    vector = new Vector3(0, 0, moveSpeed);
                if (Keyboard.GetState().IsKeyDown(Keys.Down))
                    vector = new Vector3(0, 0, -moveSpeed);

                vector = Vector3.Transform(vector, movement);
                cameraPosition.Z += vector.Z;
                cameraPosition.X += vector.X;
            }

            if (Keyboard.GetState().IsKeyDown(Keys.Left))
                cameraYaw += rotationSpeed;
            if (Keyboard.GetState().IsKeyDown(Keys.Right))
                cameraYaw -= rotationSpeed;

            if (Keyboard.GetState().IsKeyDown(Keys.Escape))
                this.Exit();

            cameraTarget = cameraPosition + Vector3.Transform(Vector3.Backward, movement);

            Matrix.CreateLookAt(ref cameraPosition, ref cameraTarget, ref cameraUpVector, out view);
                        
            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            cube.Draw();
            cubeB.Draw();

            base.Draw(gameTime);
        }
    }
}